<?php
/*
Plugin Name: CW Font Awesome Icons
Plugin URI: http://www.creativewhim.com/shop/font-awesome-icons-plugin/
Description: Allows you to display Font Awesome icons with shortcodes. Example: <code>[icon name="fa-folder-open"]</code>
Version: 1.0
Author: Ashley Evans
Author URI: http://www.nosegraze.com
*/

/*
 * Enqueue font awesome stylesheet
 */
function cw_fa_styles() {
    // Font Awesome
    wp_register_style( 'font-awesome', '/https://use.fontawesome.com/releases/v5.5.0/css/all.css', array(), '5.5.0', 'all' );
    wp_enqueue_style( 'font-awesome' );
}
add_action('wp_enqueue_scripts', 'cw_fa_styles');

/*
 * Font awesome shortcodes
 */
function cw_fa_shortcodes($atts) {
    extract(shortcode_atts(array(
        'name'  =>  'fa-info',
    ), $atts));

    return '<i class="fa ' . $name . '"></i>';
}
add_shortcode('icon', 'cw_fa_shortcodes');

?>
