<?php
/*
Plugin Name: CW Twitter Card
Plugin URI: http://www.nosegraze.com/install-twitter-cards-wordpress-blog
Description: This plugin adds Twitter Card support to your blog.
Version: 1.0
Author: Ashley Evans
Author URI: http://www.nosegraze.com
*/

function cw_twitter_card_summary() {
	global $post;
	$twitter_handle = '@YourTwitterHandle'; // Change this to your Twitter handle
	$domain = get_bloginfo('name');
	
	echo '<meta name="twitter:card" content="summary"/>';
	echo '<meta name="twitter:site" content="' . $twitter_handle . '"/>';
	echo '<meta name="twitter:domain" content="' . $domain . '"/>';
	echo '<meta name="twitter:creator" content="' . $twitter_handle . '"/>';
	echo '<meta name="twitter:title" content="' . get_the_title($post) . '">';
	echo '<meta name="twitter:description" content="' . cw_get_the_excerpt() . '">';
	
	/* The image */
	$featured_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );
	$ubb_image = get_post_meta($post->ID, '_ubb_book_image', true);
	if(!empty($featured_image)) {
		echo '<meta name="twitter:image" content="' . $featured_image[0] . '">';
	}
	elseif($ubb_image) {
		echo '<meta name="twitter:image" content="' . $ubb_image . '">';
	}
}
add_action('wp_head', 'cw_twitter_card_summary');



function cw_get_the_excerpt($id=false) {
	global $post;

	if (!$excerpt = trim($post->post_excerpt)) {
		$excerpt = $post->post_content;
		$excerpt = strip_shortcodes( $excerpt );
		$excerpt = apply_filters('the_content', $excerpt);
		$excerpt = str_replace(']]>', ']]&gt;', $excerpt);
		$excerpt = strip_tags($excerpt);
		$excerpt_length = apply_filters('excerpt_length', 55);

		$words = preg_split("/[\n\r\t ]+/", $excerpt, $excerpt_length + 1, PREG_SPLIT_NO_EMPTY);
		if ( count($words) > $excerpt_length ) {
			array_pop($words);
			$excerpt = implode(' ', $words);
			$excerpt = $excerpt . '...';
		} else {
			$excerpt = implode(' ', $words);
		}
	}

	return $excerpt;
}
?>