<?php
/*
Plugin Name: Jetpack After Post
Plugin URI: https://www.nosegraze.com/jetpack-subscription-below-blog-post/
Description: Adds a Jetpack subscription widget after each blog post.
Version: 1.0
Author: Ashley
Author URI: https://www.nosegraze.com
License: GPL2
*/

function jetpack_after_post( $content ) {
	global $post;
	$post_type = get_post_type( $post );

	// If we're not on a blog post, bail.
	if ( $post_type != 'post' ) {
		return $content;
	}

	ob_start();

	// Display the Jetpack widget.
	$instance = array();
	$args     = array(
		'before_widget' => '',
		'after_widget'  => '',
	);

	the_widget( 'Jetpack_Subscriptions_Widget', $instance, $args );

	return $content . ob_get_clean();
}

add_filter( 'the_content', 'jetpack_after_post', 500 );