<?php
/*
Plugin Name: NG Font Awesome Star Ratings
Plugin URI: https://www.nosegraze.com
Description: Allows you to easily display Font Awesome star ratings that are RSS friendly.
Version: 1.0
Author: Nose Graze
Author URI: https://www.nosegraze.com
License: GPL2
*/

/**
 * Adds the shortcode for inserting Font Awesome icons.
 *
 * Accepts one parameter called 'rating', which must be a number.
 *
 * Accepts a second paramter called 'maximum', which must also be a number.
 * Maximum will "fill up" the rating with empty stars until it reaches
 * the maximum value you entered.
 *
 * Sample Usage: [fa-rating number="4.5"]
 *
 * @param array $atts
 *
 * @return string
 */
function ng_fa_star_ratings( $atts ) {
	extract( shortcode_atts( array(
		'number'  => 5,
		'maximum' => null
	), $atts ) );

	// Not a valid number - bail.
	if ( ! is_numeric( $number ) ) {
		return '<p>' . __( 'Error: Please enter a valid number in the rating paramter.' ) . '</p>';
	}

	$output = '';

	// Get the rating as an integer.
	$rating_int = (int) $number;
	// Whether or not the original rating is a fraction.
	$is_fraction = ( $rating_int != $number ) ? true : false;

	/*
	 * If it's a fraction and we're in an RSS feed and we've set a maximum
	 * then display a plain text star. This is because the HTML half stars
	 * don't work so good!
	 */
	if ( $is_fraction === true && ! empty( $maximum ) && is_feed() ) {
		return sprintf( __( '%s Stars' ), $number );
	}

	// Get the correct star format, depending on whether we're in an RSS feed or not.
	$full_star  = is_feed() ? '&#9733;' : '<i class="fa fa-star"></i>';
	$half_star  = is_feed() ? '&frac12;' : '<i class="fa fa-star-half-o"></i>';
	$empty_star = is_feed() ? '&#9734;' : '<i class="fa fa-star-o"></i>';

	// Add one star for each rating.
	for ( $i = 0; $i < $rating_int; $i ++ ) {
		$output .= $full_star;
	}

	// If this is a fraction, add a half star at the end.
	if ( $is_fraction === true ) {
		$output .= $half_star;
	}

	// If $maximum is filled out, let's fill it up with empty stars.
	if ( ! empty( $maximum ) && $maximum > $rating_int ) {
		$stars_needed = (int) $maximum - $number;
		if ( $stars_needed > 1 ) {
			for ( $j = $stars_needed; $j >= 1; $j -- ) {
				$output .= $empty_star;
			}
		}
	}

	return $output;
}

add_shortcode( 'fa-rating', 'ng_fa_star_ratings' );