<?php
/*
Plugin Name: NG Blog Series
Plugin URI: https://www.nosegraze.com/create-blog-series/
Description: Adds a new custom taxonomy for adding posts to a blog series
Version: 1.0
Author: Nose Graze
Author URI: https://www.nosegraze.com
License: GPL2
*/

/**
 * Registers the custom taxonomy
 *
 * @return void
 */
function ng_register_blog_series_taxonomy() {

	$labels  = array(
		'name'                       => _x( 'Blog Series', 'Taxonomy General Name', 'nosegraze' ),
		'singular_name'              => _x( 'Blog Series', 'Taxonomy Singular Name', 'nosegraze' ),
		'menu_name'                  => __( 'Blog Series', 'nosegraze' ),
		'all_items'                  => __( 'All Series', 'nosegraze' ),
		'parent_item'                => __( 'Parent Series', 'nosegraze' ),
		'parent_item_colon'          => __( 'Parent Series:', 'nosegraze' ),
		'new_item_name'              => __( 'New Series Name', 'nosegraze' ),
		'add_new_item'               => __( 'Add New Series', 'nosegraze' ),
		'edit_item'                  => __( 'Edit Series', 'nosegraze' ),
		'update_item'                => __( 'Update Series', 'nosegraze' ),
		'view_item'                  => __( 'View Series', 'nosegraze' ),
		'separate_items_with_commas' => __( 'Separate series with commas', 'nosegraze' ),
		'add_or_remove_items'        => __( 'Add or remove series', 'nosegraze' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'nosegraze' ),
		'popular_items'              => __( 'Popular Series', 'nosegraze' ),
		'search_items'               => __( 'Search Series', 'nosegraze' ),
		'not_found'                  => __( 'Not Found', 'nosegraze' ),
	);
	$rewrite = array(
		'slug'         => 'series',
		'with_front'   => true,
		'hierarchical' => true,
	);
	$args    = array(
		'labels'            => $labels,
		'hierarchical'      => true,
		'public'            => true,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'show_tagcloud'     => false,
		'rewrite'           => $rewrite,
	);
	register_taxonomy( 'blog_series', array( 'post' ), $args );

}

add_action( 'init', 'ng_register_blog_series_taxonomy', 0 );

/**
 * Changes the order that the posts get displayed in
 * when we're querying a blog series. Sets the display
 * order to ascending.
 *
 * @param $query
 *
 * @return void
 */
function ng_change_blog_series_post_order( $query ) {
	if ( $query->is_main_query() && is_tax( 'blog_series' ) ) {
		// Reverse the order the posts are displayed in.
		$query->set( 'order', 'ASC' );
	}
}

add_action( 'pre_get_posts', 'ng_change_blog_series_post_order' );