(function () {
    tinymce.PluginManager.add('scroll_box_button', function (editor, url) {
        editor.addButton('scroll_box_button', {
            text: 'Scroll Box',
            icon: false,
            onclick: function () {
                editor.windowManager.open({
                    title: 'Scroll Box',
                    body: [
                        {
                            type: 'textbox',
                            name: 'scrollBoxText',
                            label: 'Add Text',
                            value: '',
                            multiline: true,
                            minWidth: 600,
                            minHeight: 500
                        }
                    ],
                    onsubmit: function (e) {
                        var box_text = e.data.scrollBoxText.replace(/\n/ig, "<br>");
                        editor.insertContent('[scroll-box]' + box_text + '[/scroll-box]');
                    }
                });
            }
        });
    });
})();