<?php
/**
 * Template Functions
 *
 * @package   twentytwelve-child
 * @copyright Copyright (c) 2016, Nose Graze Ltd.
 * @license   GPL2+
 */

/**
 * Add the parent Twenty Twelve stylesheet to the front-end.
 *
 * @since 1.0
 * @return void
 */
function twentytwelve_child_enqueue_css() {
	wp_enqueue_style( 'twentytwelve-parent', get_template_directory_uri() . '/style.css', array(), '1.0' );
	wp_add_inline_style( 'twentytwelve-parent', twentytwelve_child_customizer_css() );
}

add_action( 'wp_enqueue_scripts', 'twentytwelve_child_enqueue_css' );

/**
 * Include our Customizer settings.
 * Note: If you're using a parent theme, change get_stylesheet_directory() to get_template_directory()
 */
require get_stylesheet_directory() . '/inc/customizer/class-twentytwelve-child-customizer.php';
new Twenty_Twelve_Child_Customizer();

/**
 * Generate CSS based on the Customizer settings.
 *
 * @since 1.0
 * @return string
 */
function twentytwelve_child_customizer_css() {

	$css = '';

	$body_text = get_theme_mod( 'body_text', '#444444' );
	$css .= 'body { color: ' . $body_text . '; }';

	return $css;

}