<?php

/**
 * Implements Customizer functionality.
 *
 * Add custom sections and settings to the Customizer.
 *
 * @package   twentytwelve-child
 * @copyright Copyright (c) 2016, Nose Graze Ltd.
 * @license   GPL2+
 */
class Twenty_Twelve_Child_Customizer {

	/**
	 * Twenty_Twelve_Child_Customizer constructor.
	 *
	 * @access public
	 * @since  1.0
	 * @return void
	 */
	public function __construct() {

		add_action( 'customize_register', array( $this, 'register_customize_sections' ) );

	}

	/**
	 * Add all sections and panels to the Customizer
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @access public
	 * @since  1.0
	 * @return void
	 */
	public function register_customize_sections( $wp_customize ) {

		/*
		 * Add Panels
		 */

		// New panel for "Layout".
		$wp_customize->add_section( 'blog_layout', array(
			'title'    => __( 'Blog Layout', 'twentytwelve-child' ),
			'priority' => 101
		) );

		/*
		 * Add settings to sections.
		 */
		$this->blog_layout_section( $wp_customize );
		$this->colours_section( $wp_customize );

	}

	/**
	 * Section: Blog Layout
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @access private
	 * @since  1.0
	 * @return void
	 */
	private function blog_layout_section( $wp_customize ) {

		/* Auto add featured image */
		$wp_customize->add_setting( 'auto_add_featured_image', array(
			'default'           => true,
			'sanitize_callback' => array( $this, 'sanitize_checkbox' )
		) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'auto_add_featured_image', array(
			'label'       => esc_html__( 'Automatically Add Featured Image', 'twentytwelve-child' ),
			'description' => esc_html__( 'Check this on to automatically insert the featured image before the post content.', 'twentytwelve-child' ),
			'section'     => 'blog_layout',
			'settings'    => 'auto_add_featured_image',
			'type'        => 'checkbox',
			'priority'    => 10
		) ) );

	}

	/**
	 * Section: Colours
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @access private
	 * @since  1.0
	 * @return void
	 */
	private function colours_section( $wp_customize ) {

		/* Paragraph text */
		$wp_customize->add_setting( 'body_text', array(
			'default'           => '#444444',
			'sanitize_callback' => 'sanitize_hex_color'
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'body_text', array(
			'label'    => esc_html__( 'Body Text Colour', 'twentytwelve-child' ),
			'section'  => 'colors',
			'settings' => 'body_text',
			'priority' => 10
		) ) );

	}

	/**
	 * Sanitize Checkbox
	 *
	 * Accepts only "true" or "false" as possible values.
	 *
	 * @param $input
	 *
	 * @access public
	 * @since  1.0
	 * @return bool
	 */
	public function sanitize_checkbox( $input ) {
		return ( $input === true ) ? true : false;
	}

}